<?php

/**
 * This is the model class for table "KampaniaFirmy".
 *
 * The followings are the available columns in table 'KampaniaFirmy':
 * @property double $id
 * @property double $idFirmy
 * @property double $idKampanii
 * @property string $czasRozpoczecia
 * @property string $czasZakonczenia
 */
class KampaniaFirmy extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return KampaniaFirmy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'KampaniaFirmy';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idFirmy, idKampanii, czasRozpoczecia, czasZakonczenia', 'required'),
			array('idFirmy, idKampanii', 'numerical'),

			array('id, idFirmy, idKampanii, czasRozpoczecia, czasZakonczenia', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'firma'=>array(self::BELONGS_TO, 'Firma', 'idFirmy'),
			'kampania'=>array(self::BELONGS_TO, 'Kampanie', 'idKampanii'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('KampaniaFirmy', 'id'),
			'idFirmy'=>Yii::t('KampaniaFirmy', 'idFirmy'),
			'idKampanii'=>Yii::t('KampaniaFirmy', 'idKampanii'),
			'czasRozpoczecia'=>Yii::t('KampaniaFirmy', 'czasRozpoczecia'),
			'czasZakonczenia'=>Yii::t('KampaniaFirmy', 'czasZakonczenia'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('"id"', $this->id);
		$criteria->compare('"idFirmy"', $this->idFirmy);
		$criteria->compare('"idKampanii"', $this->idKampanii);
		$criteria->compare('"czasRozpoczecia"', $this->czasRozpoczecia, true);
		$criteria->compare('"czasZakonczenia"', $this->czasZakonczenia, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}
